﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Tank2Bullet : MonoBehaviour {

    public static Tank2Bullet instance;

    public float tank2BulletSpeed = 8f;

    public Vector2 bulletDirection;
    public bool isReady;


    void Awake () {
        isReady = false;
    }

    void Start() {
        MakeInstance();
    }

    void MakeInstance() {
        if (instance == null) {
            instance = this;
        }
    }

    void Update () {
        if (isReady) {
            Vector2 position = transform.position;
            position += bulletDirection * tank2BulletSpeed * Time.deltaTime;
            transform.position = position;
        }
    }

    public void SetBulletDirection(Vector2 direction) {
        bulletDirection = direction.normalized;
        isReady = true;
    }

    void OnTriggerEnter2D(Collider2D collision) {
        if (collision.tag == "Player") {
            PlayerHealth.instance.PlayerDamage(2);
            Destroy(gameObject);
        }

        if (collision.tag == "PlayerBullet") {
            Destroy(gameObject);
        }
    }
}
